<?php 
// if ( ! defined('BASEPATH')) exit('No direct script access allowed');
defined('BASEPATH') OR exit('No direct script access allowed');
class Manage_claim_dst extends CI_Controller {

	function __construct() {
		parent::__construct();
		$this->load->model('My_model');
		$this->load->model('Claim_model');
		$this->load->library('admin_layout');
		$this->load->helper('jsondata_helper');	
		$this->load->helper('email_helper');
	}

	function index() {
		if(!$username=$this->session->userdata('logged_in')) redirect(base_url().'login');
		$user_id = $this->session->userdata('user_id');
		$data['type'] = $this->session->userdata('type');
			
		$header_data = array(
		  'username'  		=> $username,
		  'user_id'    		=> $user_id
		);
		
		$this->admin_layout->set_title("Manage Claim");
		$this->admin_layout->set_description("");
		$this->admin_layout->set_data($header_data);

		// $get_claims = $this->My_model->get_rows('claims',array('admin_id'=>$user_id));
		$get_claims = $this->Claim_model->getclaims($user_id);
		
		$data['claims'] = $get_claims;
		$data['err_claim'] = 'No Claims available'; 
	
		$content = "admin/view_manage_claim_dst";

		if($data['type'] == 1){
			$this->admin_layout->view_dst($content,'',$data,true);
		}else{ 
			redirect(base_url().'login');
		}
		
	
	}


	public function get_docus(){
		$refno = $this->input->post('refno',TRUE);	
		$res = $this->Claim_model->getdocus($refno);
		//echo $this->db->last_query();
		$result = json_encode($res);

		echo $result;
	}

	public function get_uploaded_docus(){
		$refno = $this->input->post('refno',TRUE);	
		$res = $this->Claim_model->getdocus_uploaded($refno);
		//echo $this->db->last_query();
		$result = json_encode($res);

		echo $result;
	}	

	public function select_claim(){
		$refno = $this->input->post('refno',TRUE);	

		$res = $this->My_model->get_row('claim_application',array('refno'=>$refno));
		// echo $this->db->last_query();
		echo json_encode($res);
	}

	public function upload_docus(){

		// $ids = json_decode($_POST['docid']);
		// print_r($ids);
		$alert = "";
		// print_r($_FILES['file']);
		if(isset($_FILES['file'])){	
			
			$refno = $_POST['refno'];
			// echo 'count'.count($_FILES['file']['name']).'<br>';

			for($i=0; $i<count($_FILES['file']['name']); $i++){
				$id_exp = explode("-",$_POST['docid'][$i]);
				$doc_id = $id_exp[1];

				$target_path = $_SERVER['DOCUMENT_ROOT'] . "/shell-claims/uploads/";
				$ext = explode('.', basename( $_FILES['file']['name'][$i]));
				// $target_path = $target_path . md5(uniqid()) . '_' . $refno  . '_' . $doc_id . "." . $ext[count($ext)-1]; 
				$file_name = md5(uniqid()) . '_' . $refno  . '_' . $doc_id . "." . $ext[count($ext)-1]; 
				$target_path = $target_path . $file_name ; 
				
				// echo 'file-'.$i.':'.$_POST['name'][$i].'<br>';
				// echo 'refno-'.$i.':'.$refno .'<br>';
				// echo 'id-'.$i.':'.$_POST['docid'][$i].'<br>';
				// echo 'file-'.$i.':'.$_FILES['file']['tmp_name'][$i].'<br>';
				// echo 'cd_id-'.$i.':'.$cd_id.'<br>';


				// echo 'file_name-'.$i.':'.$file_name.'<br>';	
				//  echo 'target_path-'.$i.':'.$target_path.'<br>';	
				// echo 'file extension-'.$i.':'. $ext[count($ext)-1].'<br>';				
				// echo 'file size-'.$i.':'. $_FILES['file']['size'][$i].'<br>';	
				
				
				$extension = strtoupper($ext[count($ext)-1]);
				$filesize =  $_FILES['file']['size'][$i];

				if ($extension!="PNG" && $extension!="JPG" && $extension!="GIF" && $extension!="JPEG"  && $extension!="PDF"){
					$alert .= "Please select a valid image file (.png,.jpg,.jpeg,.pdf) for Document ".$doc_id." <br />";
				}else{
					if($filesize > 5242880){
						//20485760  20MB
						$alert .= "Document ".$doc_id." is larger than 5 MB. Upload a smaller one. <br />";
					}else{
						if(move_uploaded_file($_FILES['file']['tmp_name'][$i], $target_path)) {
							$cd_id = $this->My_model->get_value('claim_docus','cd_id',array('refno'=>$refno,'doc_id'=>$doc_id));
							// echo $this->db->last_query();
							if($cd_id){
								$this->My_model->update('claim_docus',array('cd_id'=>$cd_id),array('filename'=>$file_name,'status'=>'1'));
							}
							$alert .= "Document ".$doc_id." has been uploaded successfully <br />";
						}else{
							$alert .= "There was an error uploading the document ".$doc_id.", please try again! <br />";
						}						
					}			
				}
			}
		}else{
			$alert .= "Upload failed. Please try again <br />";
		}
		echo $alert;

	}


	public function submit_claims(){
		$user_id = $this->session->userdata('user_id');

		$refno = $this->input->post('refno',TRUE);
		$curdate = $this->input->post('curdate',TRUE);	
		$shipdate = $this->input->post('shipdate',TRUE);
		$cndbol = $this->input->post('cndbol',TRUE);
		$cuspo = $this->input->post('cuspo',TRUE);
		$shipper = $this->input->post('shipper',TRUE);
		$phonenum1 = $this->input->post('phonenum1',TRUE);
		$email1 = $this->input->post('email1',TRUE);
		$address1 = $this->input->post('address1',TRUE);
		$consigner = $this->input->post('consigner',TRUE);
		$phonenum2 = $this->input->post('phonenum2',TRUE);
		$email2 = $this->input->post('email2',TRUE);
		$address2 = $this->input->post('address2',TRUE);
		$lost = $this->input->post('lost',TRUE);
		$damaged = $this->input->post('damaged',TRUE);
		$shortshipped = $this->input->post('shortshipped',TRUE);
		$concealed = $this->input->post('concealed',TRUE);
		$claimval = $this->input->post('claimval',TRUE);

		$data_submit = array(
			'refno' => $refno,
			'curdate' => $curdate,
			'shipdate' => $shipdate,
			'cndbol' => $cndbol,
			'cuspo' => $cuspo,
			'shipper' => $shipper,
			'phonenum1' => $phonenum1,
			'email1' => $email1,
			'address1' => $address1,
			'consigner' => $consigner,
			'phonenum2' => $phonenum2,
			'email2' => $email2,
			'address2' => $address2,
			'claimval' => $claimval,
			'lost' => $lost,
			'dmg' => $damaged,
			'sship' => $shortshipped,
			'condmg' => $concealed
		  );

		// print_r($data_submit);
		$check_refno = $this->My_model->get_value('claim_application','caid',array('refno'=>$refno));

        if($check_refno){
    		$res = $this->My_model->update('claim_application',array('caid'=>$check_refno),$data_submit);
    	}else{
			$res = $this->My_model->insert('claim_application',$data_submit);
			
			// if($res){
			// 	$this->My_model->update('claims',array('refno'=>$refno),array('status'=>'1'));
			// 	$this->My_model->insert('claim_status_logs',array('refno'=>$refno, 'status_id' => '1', 'remarks' => 'For ICAM Approval'));
			// 	$this->My_model->insert('claim_alert',array('refno'=>$refno, 'message' => 'Claim submitted: For ICAM Approval'));
			// }
		}
		

		if($res){
			$icam_id = $this->My_model->get_value('claims','icam',array('refno'=>$refno));
			// echo $this->db->last_query();
			$claim_name = $this->My_model->get_value('claims','name',array('refno'=>$refno));
			$distributor = $this->My_model->get_value('admins','firstname',array('admin_id'=>$user_id));

			$today = date('Y-m-d H:i:s');
			//alert, logs, claim status update
			$this->My_model->update('claims',array('refno'=>$refno),array('status'=>'1'));
			// $this->My_model->insert('claim_status_logs',array('refno'=>$refno, 'status_id' => '1', 'remarks' => 'For ICAM Approval'));
			// $this->My_model->insert('claim_alert',array('refno'=>$refno,'admin_id'=>$icam_id,'alert_date'=>  $today, 'message' => 'Claim ('.$claim_name.') submitted: For ICAM Approval'));
						
		
			
			// echo $this->db->last_query();		


			//for email notif
			$icam_email = $this->My_model->get_value('admins','email',array('admin_id'=>$icam_id));
			// echo $this->db->last_query();	
			// $icam = $this->My_model->get_rows('admins',array('admin_id'=>$icam_id));

			// if($icam_email != "" AND $icam_email != "NULL"){	
				

				$data_claim = array(
					'claim_name' => $claim_name,
					'distributor' => $distributor,
					'date' => date("Y-m-d"),
					'link' => 'approval',
					'refno' => $refno
				);
				// print_r($data_claim);

				$recipient = $icam_email;
				$template = $this->load->view('emailtemplate',$data_claim,true);
				$subject = 'Claim Pending Your Approval';

				$headers = 'From: XPlus Support <support@xplus.ph>';
				

				$data_ebox = array(
					'emailtime'   => date("Y-m-d H:i:s"),
					'recipientname' => $recipient,
					'recipient' => $recipient,
					'header' => 'for ICAM Approval',
					'subject' => $subject,
					'admin_id' => $refno,
					'msgtype'	=> 'S',
					'message'	=> $template,
					'sent'	=> '1'
					);

				// print_r($data_ebox);

				

				
				if(email($recipient,$template,$subject)){
					echo 'success'; 
					$this->My_model->insert('ebox',$data_ebox);
					// echo $this->db->last_query();
				}else{
					echo 'email not sent!';
				}

			// }
		}

	}

}
