<?php 
// if ( ! defined('BASEPATH')) exit('No direct script access allowed');
defined('BASEPATH') OR exit('No direct script access allowed');
class Start_claim extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('My_model');
        $this->load->model('Claim_model');
        $this->load->model('Start_claim_model');
        $this->load->library('admin_layout');  
        $this->load->helper('email_helper'); 
    }

    function index() {
        if(!$username=$this->session->userdata('logged_in')) redirect(base_url().'login');
        $user_id = $this->session->userdata('user_id');
        $data['type'] = $this->session->userdata('type');

        if($data['type']!=2) redirect(base_url().'login');
            
        $header_data = array(
          'username'        => $username,
          'user_id'         => $user_id
        );
        
        $this->admin_layout->set_title("Start Claim");
        $this->admin_layout->set_description("");
        $this->admin_layout->set_data($header_data);

        $data = [];
        $data['claim_types'] = $this->My_model->get_rows('claim_types','status=1');
        $data['doc_types'] = $this->My_model->get_rows('doc_types','status=1');
        $data['dst'] = $this->My_model->get_rows('admins','type=1 AND status=1');
        
        $content = "admin/view_start_claim";
        $this->admin_layout->view($content,'',$data,true);
    
    }

    public function add_claim() {
        $user_id = $this->session->userdata('user_id');
        // echo 'admin_id:'.$_POST['admin_id'].'<br>';
        $add = $this->Start_claim_model->add_claim($_POST);

        if($add){
            $today = date('Y-m-d H:i:s');

            $this->My_model->insert('claim_status_logs',array('refno'=>$_POST['refno'], 'status_id' => '0', 'remarks' => '(ICAM) Claim opened'));
			$this->My_model->insert('claim_alert',array('refno'=>$_POST['refno'],'admin_id'=>$_POST['admin_id'],'alert_date'=>  $today, 'message' => '(ICAM) Claim opened'));
        }

        echo json_encode($add);
    }

}
