<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class My_model extends Ci_Model
{
    public function __construct()
    {
        parent::__construct();
    }
    function insert($table_name, $data)
    {
        $this->db->insert($table_name, $data);
        return ($this->db->affected_rows() != 1) ? false : $this->db->insert_id();
    }
    function insert_ignore($table_name, $data)
    {
        $insert_query = $this->db->insert_string($table_name, $data);
        $insert_query = str_replace('INSERT INTO', 'INSERT IGNORE INTO', $insert_query);
        $this->db->query($insert_query);
        return ($this->db->affected_rows() != 1) ? false : $this->db->insert_id();
    }
    function insert_batch($table_name, $data) {
        $this->db->insert_batch($table_name, $data);
        return $this->db->affected_rows();
    }
    //Batch Insert Ignore
    function batch_insert($table_name, $data)
    {
        foreach ($data as $data_item) {
            $insert_query = $this->db->insert_string($table_name, $data_item);
            $insert_query = str_replace('INSERT INTO', 'INSERT IGNORE INTO', $insert_query);
            $this->db->query($insert_query);
            // echo $this->db->last_query();
        }
    }

    //Batch Insert Ignore
    function batch_insert_duplicate($table_name, $data, $i = 0)
    {
        foreach ($data as $data_item) {
            $onkeyupdate = "";
            foreach ($data_item as $key => $value) {
                if ($i > 0) {
                    $onkeyupdate .= $key . "='$value',";
                }
                $i++;
            }
            $onkeyupdate = rtrim($onkeyupdate, ',');
            $insert_query = $this->db->insert_string($table_name, $data_item) . ' ON DUPLICATE KEY UPDATE ' . $onkeyupdate;
            $insert_query = str_replace('INSERT INTO', 'INSERT IGNORE INTO', $insert_query);
            $this->db->query($insert_query);
            // echo $this->db->last_query();
        }
    }

    function batch_insert_duplicate_count($table_name, $data)
    {
        $i = count($data);
        foreach ($data as $data_item) {
            $onkeyupdate = "";
            foreach ($data_item as $key => $value) {
                if ($i > 0) {
                    $onkeyupdate .= $key . "='$value',";
                }
                $i++;
            }
            $onkeyupdate = rtrim($onkeyupdate, ',');
            $insert_query = $this->db->insert_string($table_name, $data_item) . ' ON DUPLICATE KEY UPDATE ' . $onkeyupdate;
            $insert_query = str_replace('INSERT INTO', 'INSERT IGNORE INTO', $insert_query);
            
            if(!$this->db->query($insert_query)) return false;
            // echo $this->db->last_query();
        }

        return true;
    }

    //insert update duplicate data length
    function insert_update_duplicate_count($table_name, $data)
    {
        $i = count($data);
        $onkeyupdate = "";
        foreach ($data as $key => $value) {
            if ($i > 0) {
                $onkeyupdate .= $key . "='$value',";
            }
            $i++;
        }
        $onkeyupdate = rtrim($onkeyupdate, ',');

        $sql = $this->db->insert_string($table_name, $data) . ' ON DUPLICATE KEY UPDATE ' . $onkeyupdate;
        $this->db->query($sql);
        return $this->db->insert_id();
        //return $this->db->_error_message();
    }

    //insert update duplicate
    function insert_update_duplicate($table_name, $data, $i = 0)
    {
        $onkeyupdate = "";
        foreach ($data as $key => $value) {
            if ($i > 0) {
                $onkeyupdate .= $key . "='$value',";
            }
            $i++;
        }
        $onkeyupdate = rtrim($onkeyupdate, ',');

        $sql = $this->db->insert_string($table_name, $data) . ' ON DUPLICATE KEY UPDATE ' . $onkeyupdate;
        $this->db->query($sql);
        return $this->db->insert_id();
        //return $this->db->_error_message();
    }

    //insert update duplicate2
    function insert_update_duplicate2($table_name, $data, $onkeyupdate)
    {
        $sql = $this->db->insert_string($table_name, $data) . ' ON DUPLICATE KEY UPDATE ' . $onkeyupdate;
        $this->db->query($sql);
        return $this->db->insert_id();
        //return $this->db->_error_message();
    }

    //$id-fld is the ID field name
    function update($table_name, $where, $data)
    {
        $this->db->where($where);
        $this->db->update($table_name, $data);
        return $this->db->affected_rows() > 0;
    }

    function update_row($table_name, $where, $data)
    {
        $this->db->where($where);
        $this->db->update($table_name, $data);
        //echo $this->db->last_query();
        return $this->db->affected_rows() > 0;
    }

    function get_value($table_name, $column_name, $where)
    {
        $query = $this->db
            ->select($column_name)
            ->from($table_name)
            ->where($where)
            ->get();
        //echo $this->db->last_query();
        if (!$query) return false;
        if ($query->num_rows() > 0) {
            $row = $query->first_row('array');
            return $row[$column_name];
        } else return false;
    }
    function get_row($table_name, $where)
    {
        $query = $this->db
            ->select()
            ->from($table_name)
            ->where($where)
            ->limit(1)
            ->get();
        if (!$query) return false;
        if ($query->num_rows() > 0) return $query->first_row();
        else return false;
    }

    function get_last_row($table_name, $select, $where, $orderby = NULL)
    {
        $query = $this->db
            ->select($select, FALSE)
            ->from($table_name)
            ->where($where)
            ->limit(1)
            ->order_by($orderby)
            ->get();
        if (!$query) return false;
        if ($query->num_rows() > 0) return $query->first_row();
        else return false;
    }

    function query_row($table_name, $select, $where)
    {
        $query = $this->db
            ->select($select, FALSE)
            ->from($table_name)
            ->where($where)
            ->limit(1)
            ->get();
        if (!$query) return false;
        if ($query->num_rows() > 0) return $query->first_row();
        else return false;
    }

    function get_rows($table_name, $where, $orderby = NULL, $limit = 9999999)
    {
        $this->db->select();
        $this->db->from($table_name);
        $this->db->where($where);
        if ($orderby != NULL || $orderby != '') $this->db->order_by($orderby);
        $this->db->limit($limit);
        $query = $this->db->get();
        if (!$query) return false;
        if ($query->num_rows() > 0) return $query->result();
        else return false;
    }

    function get_rows_array($table_name, $where, $orderby = NULL, $limit = 9999999)
    {
        $this->db->select();
        $this->db->from($table_name);
        $this->db->where($where);
        if ($orderby != NULL || $orderby != '') $this->db->order_by($orderby);
        $this->db->limit($limit);
        $query = $this->db->get();
        if (!$query) return false;
        if ($query->num_rows() > 0) return $query->result_array();
        else return false;
    }

    function query_rows($table_name, $select, $where, $orderby = NULL, $limit = 99999999)
    {
        $this->db->select($select, FALSE);
        $this->db->from($table_name);
        $this->db->where($where);
        if ($orderby != NULL || $orderby != '') $this->db->order_by($orderby);
        $this->db->limit($limit);
        $query = $this->db->get();
        if (!$query) return false;
        if ($query->num_rows() > 0) return $query->result();
        else return false;
    }

    function get_row_join($select = "", $tables, $ids, $where)
    {
        $x = 0;
        $on_fields = array();
        $t_count = sizeof($tables);

        for ($i = 0; $i < $t_count - 1; $i++) {
            $x = $i + 1;
            $on_fields[$i] = 't' . $i . '.' . $ids[$i] . '=t' . $x . '.' . $ids[$i];
        }

        $this->db->select($select, FALSE);
        $this->db->from($tables[0] . ' t0');

        $i = 1;
        foreach ($on_fields as $on) {
            $this->db->join($tables[$i] . ' t' . $i, $on, "left");
            $i++;
        }

        $this->db->where($where);
        $this->db->limit(1);

        $query = $this->db->get();
        if (!$query) return false;
        if ($query->num_rows() > 0) return $query->first_row();
        else return false;
    }

    function get_rows_join($select = "", $tables, $ids, $where, $orderby = NULL, $limit = 9999999)
    {
        $x = 0;
        $on_fields = array();
        $t_count = sizeof($tables);

        for ($i = 0; $i < $t_count - 1; $i++) {
            $x = $i + 1;
            $on_fields[$i] = 't' . $i . '.' . $ids[$i] . '=t' . $x . '.' . $ids[$i];
        }

        $this->db->select($select, FALSE);
        $this->db->from($tables[0] . ' t0');

        $i = 1;
        foreach ($on_fields as $on) {
            $this->db->join($tables[$i] . ' t' . $i, $on, "left");
            $i++;
        }

        $this->db->where($where);
        if ($orderby != NULL) $this->db->order_by($orderby);
        $this->db->limit($limit);
        $query = $this->db->get();

        if (!$query) return false;
        if ($query->num_rows() > 0) return $query->result();
        else return false;
    }

    function get_count($table, $count, $where)
    {
        $select = "COUNT(" . $count . ") result";

        $query = $this->db
            ->select($select)
            ->from($table)
            ->where($where)
            ->get();

        if (!$query) return 0;
        if ($query->num_rows() > 0) {
            $result = $query->first_row();
            return $result->result;
        } else return 0;
    }

    function get_sum($table, $sum, $where)
    {
        $select = "SUM(" . $sum . ") result";

        $query = $this->db
            ->select($select)
            ->from($table)
            ->where($where)
            ->get();

        if (!$query) return 0;
        if ($query->num_rows() > 0) {
            $result = $query->first_row();
            return $result->result;
        } else return 0;
    }

    function union_all($tables, $select = NULL, $where, $orderby = NULL, $limit = 99999999)
    {
        $i = 0;
        $union = "";
        foreach ($tables as $table) {
            $u_sql = "SELECT " . $select .
                " FROM " . $table . " AS t" . $i .
                " WHERE " . $where;

            if ($i == 0) {
                $union = $u_sql;
            } else {
                $union .= " UNION ALL " . $u_sql;
            }
            $i++;
        }

        $sql = "SELECT * FROM (" . $union . ") AS ut";
        if ($orderby !== NULL) $sql .= " ORDER BY " . $orderby;
        $sql .=  " LIMIT " . $limit;
        $query = $this->db->query($sql);
        if (!$query) return false;
        if ($query->num_rows() > 0) return $query->result();
        return false;
    }


    function get_fieldnames($table_name)
    {
        return $this->db->list_fields($table_name);
    }
    function get_field_data($table_name)
    {
        $query = $this->db
            ->select('column_name AS FieldName,
                column_type AS Type,
                column_default AS "Default",
                column_comment AS Comment')
            ->from('information_schema.columns')
            ->where('table_name', $table_name)
            ->get();
        if ($query->num_rows() > 0) return $query->result();
        else return false;
    }

    function get_table_id($table_name)
    {
        $fields = $this->db->field_data($table_name);
        foreach ($fields as $field) {
            return $field->name;
            break;
        }
    }
}
