
<style>

  .wrap-claim {
    background: #fff;
    border-radius: 10px;
    overflow: hidden;
    padding: 62px 55px 90px 55px;
  }

  .sform1 {
    padding-top: 5%;
  }

  .docs {
    padding-top: 5%;
    padding-left: 5%;
  }

  .col{
    padding-left: 0px;
  }

  .submit{
    margin-top: 3%;
  }

  .form-control.is-invalid, .was-validated .form-control:invalid {
    border-color: #e74a3b;
    padding-right: calc(1.5em + .75rem);
    background-image: url(data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='%23e74a3b' viewBox='-2 -2 7 7'%3e%3cpath stroke='%23e74a3b' d='M0 0l3 3m0-3L0 3'/%3e%3ccircle r='.5'/%3e%3ccircle cx='3' r='.5'/%3e%3ccircle cy='3' r='.5'/%3e%3ccircle cx='3' cy='3' r='.5'/%3e%3c/svg%3E);
    background-repeat: no-repeat;
    background-position: center right calc(.375em + .1875rem);
    background-size: calc(.75em + .375rem) calc(.75em + .375rem);
  }  
  .form-control:focus {
    color: #3a3b45 !important;
    background-color: #fff;
    border-color: #bac8f3;
    outline: 0;
    -webkit-box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, .25);
    box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, .25);
  }

</style>

<div class="row" style="padding:9px;background: #fff;color: #000;border-bottom: 1px solid #717171;">
  <div class="container mt-0">
    <div class="row col-lg-12">
      <ul class="nav nav-pills">
        <li class="nav-item">
          <a class="nav-link pr-3 <?= current_url() == base_url().'start_claim' ? 'active' : ''?>" href="<?= base_url().'start_claim' ?>" >Start a Claim</a>
        </li>
        <li class="nav-item">
          <a class="nav-link pr-3 <?= current_url() == base_url().'claim_report_icam' ? 'active' : ''?>" href="<?= base_url().'claim_report_icam' ?>" >Report</a>
        </li>
      </ul>
    </div>
  </div>
</div> 


<div class="wrap-claim">
  <div class="row">
    <div class="col-lg-4 pl-5" style="padding:0px;margin:0px;">
      <div class="row">
        <div class="col-12"><h2>Create a New Claim</h2></div>
      </div>
      <div class="row sform1">
        <div class="form-group col-lg-4">
          <label for="ref_no">Ref. No</label>
          <input type="text" class="form-control reqInput" id="ref_no" value="<?= time() . rand(10*45, 100*98) ?>">
        </div>      
        <div class="form-group col-lg-4">
          <label for="claim_name">Claim Name</label>
          <input type="text" class="form-control reqInput" id="claim_name">
        </div>      
        <div class="form-group col-lg-4">
          <label for="claim_type">Claim Type</label>
          <select class="custom-select reqInput" id="claim_type" required>
            <option selected disabled value="">Choose...</option>
            <?php
              foreach($claim_types as $key => $claim) {
                echo "<option value='$claim->ct_id'>$claim->type</option>";
              }
            ?>
          </select>
        </div>
        <div class="form-group col-lg-8">
          <label for="dst">Distributor</label>
          <select class="custom-select reqInput" id="dst" required>
            <option selected disabled value="">Choose...</option>
            <?php
              foreach($dst as $key => $row) {
                echo "<option value='$row->admin_id'>$row->firstname</option>";
              }
            ?>
          </select>
        </div>
      </div>
    </div>
    <div class="col-lg-8 docs">
      <div class="row"><h5 class="ml-5 mb-4 col">Document Types</h5></div>
      <div class="row">
        <?php
          foreach($doc_types as $key => $doc) {
            $default = ($key == 0) ? 'checked' : '';
            echo "
              <div class='custom-control custom-checkbox ml-5 mb-2 col-12'>
                <input type='checkbox' class='custom-control-input doc_types' id='dt_$doc->id' $default value='$doc->id' data-desc='$doc->description'>
                <label class='custom-control-label' for='dt_$doc->id'>$doc->type</label>
              </div>
            ";
          }
        ?>
      </div>
    </div>
  </div>
  <div class="row submit">
    <div class="col-12 pl-5">
      <button id="action-submit" class="btn btn-primary add_claim">Submit</button>
    </div>
  </div>
</div>

<script>
        
$(document).ready(function() {
  validateForm();

  $('.reqInput').keyup(function() {
    validateForm();
  });

  $('select.reqInput').change(function() {
    validateForm();
  });

  function validateForm() {
    var valid = true;
    $('.reqInput').each(function() {
      $(this).removeClass('is-invalid');
      // alert($(this).val());
      if ($(this).val() === '' || $(this).val() == 'null' ) {
          valid = false;
              $(this).addClass('is-invalid');
      }
    });

    if (valid == true) {
      $('.reqInput').removeClass('is-invalid');
      $('.add_claim').prop('disabled', false);
      $('.newWarning').hide();
    } else {
      $('#action-submit').prop('disabled', true);
      $('.newWarning').show();
    }
  }  




  var base_url = '<?= base_url() ?>';

  $('.add_claim').on('click', function(e) {
    var docus = [];
    $('.doc_types:checked').each(function(i, row) {
        docus.push({
            refno: $('#ref_no').val().trim(),
            doc_id: $(row).val(),
            description: $(row).data('desc'),
            status: 0
        });
    });

    console.log('docus => ', docus);
    // return;
    Swal.fire({
              title: 'WARNING !',
              text: "Are you sure you want to Submit?",
              type: 'info',
              showCancelButton: true,
              confirmButtonColor: '#3085d6',
              cancelButtonColor: '#d33',
              confirmButtonText: 'Yes'
              }).then((result) => {
              if (result.value) {
                  //preSave();

                  if($('#claim_type').val() == null || $('#dst').val() == null)   {
                    Swal.fire({
                      type: 'info',
                      title: 'Please select a Claim Type/Distributor!',
                      // text: 'cancelled!',
                    });
                  }else{
                    $.ajax({
                      url: base_url+'start_claim/add_claim',
                      method: 'POST',
                      dataType: 'json',
                      data: {
                          refno: $('#ref_no').val().trim(),
                          name: $('#claim_name').val().trim(),
                          ct_id: $('#claim_type').val(),
                          admin_id: $('#dst').val(),
                          docus: docus
                      },
                      success: function(data){   

                        Swal.fire({
                          type: 'success',
                          title: 'Success',
                          text: 'Claim successfully opened!',
                        });
                        window.location.replace("<?= base_url().'claim_report_icam' ?>");

                      },
                    })
                    // .then(function(res) {
                    //     console.log('res => ', res);
                    // });
                  }
 		
              }
              else {
                  Swal.fire({
                      type: 'info',
                      title: 'Cancelled!',
                      // text: 'cancelled!',
                  });
                  // $("#Modal").modal('hide');
              }
        });

  });
  
});
</script>
</body>
</html>