/**********************************************************
 * dbTable function
 **********************************************************/
(function ($) {
	'use strict';
	$.fn.dbTable = function (param) {
		var defaults = {
			hidden_col: 0,
			counter: true,
			counter_dir: 'asc',
			sort_col: {},
			sort_dir: 'asc',
			selected_class: 'success',
			select_multi: false,
			currency_colname: ['price',
				'amount',
				'balance',
				'total',
				'net sales',
				'gross sales',
				'collected amount',
				'received amount',
				'shipping fee',
				'product cost',
				'total cv',
				'debit',
				'credit',
				'payout',
				'total payout',
				'retail profit',
				'personal rebate',
				'tier payout',
				'homes cost',
				'rate',
				'subtotal',
				'vouchers_payable',
				'ms_amt',
				'os_amt',
				'me_amt',
				'dr_sund',
				'cr_sund',
				'unit_cost',
				'cost',
				'amt_501',
				'amt_502',
				'amt',
				'debit_amount',
				'credit_amount'

			]
		};
		var table_id = this.prop('id');
		var table_ids = {
			this_table_id: table_id
		};
		var options = $.extend(true, {}, defaults, param, table_ids);
		//var table_id = this.prop('id');
		this.html('<thead id="' + table_id + '_my-thead" class="thead-default"></thead>');
		var m_options = {
			cur_col: thead(options)
		};

		var more_options = $.extend(options, m_options);

		tbody(more_options);
	}

	function thead(options) {
		var table_id = options.this_table_id;
		var colcount = 0;
		var cols = options.data.cols;
		var cur_col = [];
		var th = '<tr>';

		if (options.counter) {
			th += '<th class="text-center">#</th>';
		}
		cols.forEach(function (col) {
			if ($.inArray(col[0].toLowerCase(), options.currency_colname) > -1) {
				cur_col.push(colcount);
				th += '<th class="text-right">' + col.toString().replace(/_/g, " ") + '</th>'
			} else if (colcount != options.hidden_col) {
				th += '<th class="text-center">' + col.toString().replace(/_/g, " ") + '</th>'
			}
			colcount++;
		});

		th += '</tr>'
		$('#' + table_id + '_my-thead')
			.html(th)
			.css({
				'text-transform': 'uppercase'
			});
		return cur_col;
	}

	function tbody(options) {
		var table_id = options.this_table_id;
		var rows = options.data.values;
		var selectedClass = options.selected_class;
		var x = 1; //counter direction.
		var rowcounter = 1;
		if (options.counter) {
			var max_count = rows.length;
			if (options.counter_dir.toLowerCase() === 'desc') {
				x = -1;
				rowcounter = max_count;
			}
		}

		var tb = '<tbody id="' + table_id + '_my-tbody">';

		rows.forEach(function (row) {
			var colcount = 0;
			row.forEach(function (val) {
				if (colcount == 0) {
					tb += '<tr id="' + table_id + '_trid-' + val + '">';
					if (options.counter) tb += '<td>' + rowcounter + '</td>';
				} else {
					if (colcount != options.hidden_col) {
						if ($.inArray(colcount, options.cur_col) > -1) {
							tb += '<td class="text-right">' + tomoney(val) + '</td>';
						} else if (/^[+-]?\d+(\.\d+)?$/.test(val)) {
							tb += '<td class="text-rightx">' + val + '</td>';
						} else {
							var align_text = (/\//g.test(val)) ? 'class="text-left"' : 'class="text-left"';
							tb += '<td ' + align_text + '>' + val + '</td>';
						}
					}
				}
				colcount++;
			});
			tb += '</tr>';
			rowcounter += x;
		});
		tb += '</tbody>';
		$('#' + table_id + '_my-thead').after(tb);

		$('#' + table_id + ' tbody').on('click', 'tr', function () {
			if (options.select_multi) {
				$(this).toggleClass(selectedClass);
			} else {
				$(this).toggleClass(selectedClass).siblings().removeClass(selectedClass);
				if ($(this).hasClass(selectedClass)) {
					if (typeof selectListener === 'function') selectListener($(this));
				}
			}
			if (typeof rowClickListener === 'function') rowClickListener($(this));
			return false;
		});

		$('#' + table_id + ' tbody > tr').dblclick(function (e) {
			e.preventDefault();
			$(this).addClass(selectedClass).siblings().removeClass(selectedClass);
			//var rowid = $(this).attr('id');
			if (typeof dblClickListener === 'function') dblClickListener($(this));
		});

		$('#' + table_id + ' tbody > tr').contextmenu(function (e) {
			if (typeof contextMenu === 'function') {
				e.preventDefault();
				$(this).addClass(selectedClass).siblings().removeClass(selectedClass);
				contextMenu($(this));
			}
		});
	}

	function tomoney(value) {
		return value.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1,");
	}
}(jQuery));
