/* =========================================================
 * bootstrap-dbtable.js
 * =========================================================
 * Created by Julio Magallanes 2016-07-06.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ========================================================= */
 (function($) {
 	'use strict';
    $.fn.dbTable = function(options,data) {
		var defaults = {
			'columns'				: [],
			'headBackground'		: 'alert-primary',
			'headCss'				: {'textTransform':'capitalize',
									   'text-align':'center'},
			'hideFirstCol'	 		: 'Y',
			'displayCounter' 		: 0, //0= No;1=ASC; -1=DESC
			'formatNumberColumns'	: {},  //column names to display in number format
			'sumColumns'			: {},  //column names to calculate and display sum
			'textAlignColumns'		: {'#' : 'right'},
			'backgroundColumns'		: {},
			'allowSelectRow'		: 'N',
			'selectedRowClass'		: 'success',
		};
		var opts = $.extend(true,{},defaults,options);
		var tableId=this.attr('id');
		opts.tableId = tableId;
		//Head section
		if(opts.columns != []) {
			var head= '#'+tableId;
			$(head).html(tableHeader(opts));
			$(head+ ' th').css(opts.headCss);
			$(head+ ' thead').addClass(opts.headBackground);
		}

		//Body section
		var elem = '#'+tableId+' > tbody';
		$(elem).append(tableBody(options,data));
		if(opts.hideFirstCol.toUpperCase() == 'Y') {
			var hideCol = 1 + Math.abs(opts.displayCounter);

			$('th:nth-child('+hideCol+')').hide();
			$('td:nth-child('+hideCol+')').hide();
		}
		if(opts.allowSelectRow.toUpperCase() == 'Y') {
			$('tbody').on( 'click', 'tr', function () {
				$(this).toggleClass(opts.selectedRowClass).siblings().removeClass(opts.selectedRowClass);
			});
		}

		var sumIndex=[];
		if(opts.sumColumns != {}) {
			$.each(opts.sumColumns,function(i,val) {
				var colIndex = opts.columns.indexOf(val);
				sumIndex[val]=getSum(colIndex + 1 + Math.abs(opts.displayCounter));
			});
		}

		if(opts.formatNumberColumns != {}) {
			$.each(opts.formatNumberColumns,function(i,val) {
				var colIndex = opts.columns.indexOf(val);
				formatNumber(colIndex + 1 + Math.abs(opts.displayCounter));
			});
		}

		if(opts.textAlignColumns !={}) {
			$.each(opts.textAlignColumns,function(key,val) {
				var colIndex = opts.columns.indexOf(key);
				alignText(colIndex + 1 + Math.abs(opts.displayCounter),val);
			});
		}

		if(opts.backgroundColumns !={}) {
			$.each(opts.backgroundColumns,function(key,val) {
				var colIndex = opts.columns.indexOf(key);
				backgroundColumn(colIndex + 1 + Math.abs(opts.displayCounter),val);
			});
		}

		return this;
	}

	function tableHeader(opts) {
		var head = '';
		head += '<thead>';

		var order = parseInt(opts.displayCounter);
		if(order != 0) {
			head += '<th>#</th>';
		}
		var data = opts.columns;
		data.forEach(function(col){
			head +='<th>'+col.replace(/_/g, ' ')+'</th>';
		});
		head +='</tr></thead>';
		head +='<tbody></tbody>';
		return head;
	}
	// (/yes/i.test(str))
	function tableBody(opts,data) {
		// var company_code = <?php echo json_encode($_SESSION['company_code']); ?>;
		var tbody ='';
		var cntr = 1;
		var maxCount = Object.keys(data).length;

		var order = parseInt(opts.displayCounter);

		$.each(data,function(key,obj) {
			tbody +='<tr>';
			if (order == 1 || order == -1) {
				cntr = (order > 0) ? cntr  : maxCount--;
				tbody+='<td>'+cntr+'</td>';
				cntr++;
			}
			$.each(obj,function(k,value) {
				var val = value;
				var string = value + '';
				var str = JSON.stringify(value);
				// var regex = /(pizza)/g;
				if (str.indexOf(".jpg") > 0){
					var val2 = string.split('~');
					var company_code = val2[0];
					var file = val2[1];
          var type = val2[2];
          if(type == 'signatures'){
            var url = 'https://moses_signatures.storage.googleapis.com/'+company_code+'/'+file;
          }else if (type == 'pictures') {
            var url = 'https://moses_pictures.storage.googleapis.com/'+company_code+'/'+file;
          }else{
  					var url = 'https://moses_signatures.storage.googleapis.com/'+company_code+'/'+file;
          }
					tbody+='<td width="20%" align="center"><a href="#signaturemodal" data-toggle="modal" data-img-url="'+url+'"><img style="margin-bottom:0px !important;" class="text-center thumbnail" src="'+url+'" width="80px" height="80px"></a></td>';
				}else{
					tbody+='<td>'+value+'</td>';
				}
			});
			tbody +='</tr>';
		});
		return tbody;
	}

	// function tableBody(opts,data) {
	// 	var tbody ='';
	// 	var cntr = 1;
	// 	var maxCount = Object.keys(data).length;

	// 	var order = parseInt(opts.displayCounter);

	// 	$.each(data,function(key,obj) {
	// 		tbody +='<tr>';
	// 		if (order == 1 || order == -1) {
	// 			cntr = (order > 0) ? cntr  : maxCount--;
	// 			tbody+='<td>'+cntr+'</td>';
	// 			cntr++;
	// 		}
	// 		$.each(obj,function(k,value) {
	// 			tbody+='<td>'+value+'</td>';
	// 		});
	// 		tbody +='</tr>';
	// 	});
	// 	return tbody;
	// }

	function getSum(i) {
		var sum = 0;
		$('td:nth-child('+i+')').each(function(x) {
			sum += parseInt($(this).html());
		});

		return sum;
	}

	function formatNumber(i) {
		$('td:nth-child('+i+')').each(function(x) {
			var oldVal = $(this).html();
			var newVal = oldVal.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
			$(this).html(newVal);
			$(this).addClass("text-right");
		});
	}

	function alignText(i,align) {
		$('td:nth-child('+i+')').each(function(x) {
			$(this).removeClass();
			$(this).addClass('text-'+align);
		});
	}

	function backgroundColumn(i,style) {
		$('td:nth-child('+i+')').each(function(x) {
			$(this).addClass(style);
		});
	}

}( jQuery ));
