//Create Overlays as Geofence
//divs=> map,contextmenu, loading-img, mask
//styles=> mask, loading-img	
	var drawingManager;
	var selectedShape;
	var colors = ['#1E90FF', '#FF1493', '#32CD32', '#FF8C00', '#4B0082'];
	var selectedColor;
	var selectedZone;
	var selectedIndex;
	var colorButtons = {};
	var map;
	  
	//var circleArray = [];
	var overlayArray =[];
	var zoneNames=[];
	var oIndex=0;
	
	var initZoom=16;
	var initLatlng = new google.maps.LatLng(14.4760787174,120.9934442026);
	var drawControlStatus = true;
	
	
	function eventListeners() {
		google.maps.event.addListener(map, 'click', clearSelection);
		google.maps.event.addListener(map, 'rightclick', oContextMenu);		
		google.maps.event.addDomListener(document.getElementById('delete-action'), 'click', deleteSelectedShape);
		// google.maps.event.addDomListener(document.getElementById('save-action'), 'click', saveOverlays);
		google.maps.event.addDomListener(document.getElementById('control-action'), 'click', drawingControl);
		google.maps.event.addDomListener(document.getElementById('btn-oname'), 'click', assign_zone);			
		//google.maps.event.addDomListener(document.getElementById('show-hide-control'), 'click', drawingControl);
		
	}
	
	function drawingControl() {		
		if (drawControlStatus) drawControlStatus=false;
		else drawControlStatus=true;		
		drawingManager.setOptions({  drawingControl: drawControlStatus});
		$("#control-action").attr("checked",drawControlStatus);		
	}
	
	function clearSelection() {
		if (selectedShape) {
		  selectedShape.setEditable(false);
		  selectedShape = null;
		}
		$('#ocontextmenu').hide();
	}
	
	function setSelection(shape) {
		clearSelection();
		selectedShape = shape;
		shape.setEditable(true);		
		selectColor(shape.get('fillColor') || shape.get('strokeColor'));
		//Set Selected Zone
		selectedIndex=shape.zIndex;
		selectedZone = zoneNames[selectedIndex]; 
	}
	
	function deleteSelectedShape() {
		$('#ocontextmenu').hide();
		if (selectedShape) {
		  selectedShape.setMap(null);
		  console.log('shapeindex~'+selectedShape.zIndex);
		  console.log('before~'+overlayArray);
		  overlayArray.splice(selectedShape.zIndex,1);	
		  console.log('after~'+overlayArray);
		}
		saveOverlays();		
	}
	
	function oContextMenu() {
		$('#zonename').val(selectedZone);			
		$('#ocontextmenu').show();
		return false;
	}
	
	function oSelectMenu(shape) {
		setSelection(shape);
		oContextMenu()
	}
	
	//********************************************
	function drawSavedOverlay() {		
		for (index in savedOverlays) createShape(savedOverlays[index],index);
	
		function createShape(data) {						
			var shapeOptions ={				
				fillColor: data.fillcolor,
				fillOpacity:data.fillopacity,
				strokeColor: data.strokecolor, 
				strokeOpacity: data.strokeopacity, 
				strokeWeight: data.strokeweight 
			};			
			switch (data.otype) {
				case 'C':
					//create circle
					var $coordinates = data.latlng.split(",");
					var center = new google.maps.LatLng($coordinates[0],$coordinates[1]);
					var radius =parseFloat(data.radius);
									
					var newShape = new google.maps.Circle({
						map:map,
						center:center,
						radius:radius					
					});
					break;
				case 'R':
					//create rectangle
					var $pll = data.latlng.split(',');					
					bounds = new google.maps.LatLngBounds(
						new google.maps.LatLng($pll[0],$pll[1]),
						new google.maps.LatLng($pll[2],$pll[3])					
					);
					
					var newShape = new google.maps.Rectangle({
						map:map,
						bounds:bounds						
					});					
					break;	
				case 'P':
					//create polygon					
					var $vertices = data.latlng.split(";");	
					
					var $paths=[];
					for (var index in $vertices) {
						$coordinates = $vertices[index].split(",");
						$paths[index] = new google.maps.LatLng($coordinates[0],$coordinates[1]);						
					}									
													
					var newShape = new google.maps.Polygon({ 
						map: map, 
						path: $paths						
					});
										
					break;
						
			}
			
			newShape.setOptions(shapeOptions);				
			newShape.zIndex = oIndex;
			
			overlayArray.push(newShape);
			
			zoneNames.push(data.zonename);			
			oIndex += 1;		
						
			google.maps.event.addListener(newShape, 'click', function() {
				setSelection(newShape);	
			});
			google.maps.event.addListener(newShape, 'rightclick', function() {
				setSelection(newShape);	
				oContextMenu();
			});						
		}
	}	  
	
	function saveOverlays() {
		$('#ocontextmenu').hide();	
		if (oIndex > 0) {
			
			//$('<div id="loading-img" title="Loader Image"><img src="http://xplustrack.com/images/map/loading-green.gif"/></div>').appendTo("body");
			//$('<div id="mask" title="Page Mask"><img src="http://xplustrack.com/images/map/loading-green.gif"/></div>').appendTo("body");
			/*	  
			$('<div />', { 
				id: 'loading-img',
				title: 'Loader Image',			 
				html: '<img src="http://xplustrack.com/images/map/loading-green.gif"/>' 
			}).appendTo('body');
			
			$('<div />', { 
				id: 'mask',
				title: 'Page Mask'				 
			}).appendTo('body');
			*/
		  //applyMask('#loading-img');		  		  
		  
		  var $overlays = [];		  
		  for (Index in overlayArray) {	 
			var shape = overlayArray[Index];
			$radius = 0;
			try {
				$radius = parseFloat(shape.getRadius());
			}
			catch(err){}
			if ($radius > 0) {
				var $oType = 'C';				
				var $latlng = shape.getCenter().toString();	
			}
			else {
				try {
					var $path=shape.getPath();
					//Polygon
					$oType = 'P';
					var $latlng="";
					for (var i=0;i<$path.length;i++) {
						if ($latlng=="") $latlng = $path.getAt(i);
						else $latlng += ';' +  $path.getAt(i);
					}
				}
				catch(err){
					$oType = 'R';					
					$latlng = shape.bounds.toString();	
				}
			}					
				
			var $oInfo = {
				otype: $oType,
				zonename:zoneNames[Index],
				radius: $radius,
				latlng: $latlng,
				fillcolor: shape['fillColor'],
				fillopacity: shape['fillOpacity'],
				strokecolor: shape['strokeColor'],
				strokeopacity: shape['strokeOpacity'],
				strokeweight: shape['strokeWeight']
			};
			$overlays.push($oInfo);	
		  }
			
		// aurl="<?=base_url()?>map/insert_zones";
		// aurl="http://xplus.ph/des/map/insert_zones";
		// param = {tkrid:$tkrid,geofence:$overlays,agentid:$agentid};	
		// ajpost(aurl,param);			
		aurl='insert_zones';
		var agent_id2 = $('#agents').val();
		// console.log($agent_id+'~~~'+$('#agents').val());
		// param = {admin_id:$admin_id,geofence:$overlays,agent_id:$agent_id};	
		// ajpost(aurl,param);	
		$.ajax({
            type: "POST",
            url: aurl,
            data: {'agent':agent_id2,'admin_id':$admin_id,'geofence2':$overlays},
            dataType: "text",
            success: function(data){
            	console.log(agent_id2);
            	console.log(typeof agent_id2);
            	$('#zonename').val('');
                // alert(data+'agid2~'+$agent_id2);
                // $('#topbar-submit').trigger('click');
            }
        });	 
	  }
	}
	
	function assign_zone() {
		// alert($('#zonename').val());
		$zonename = $('#zonename').val();
		$zonename = $zonename.replace("'","`");
		zoneNames[selectedIndex]=$zonename;
		saveOverlays();
		clearSelection();
	}
	
	//********************************************
	
	function selectColor(color) {
		selectedColor = color;
		for (var i = 0; i < colors.length; ++i) {
		  var currColor = colors[i];
		  colorButtons[currColor].style.border = currColor == color ? '2px solid #789' : '2px solid #fff';
	}
	
	// Retrieves the current options from the drawing manager and replaces the
	// stroke or fill color as appropriate.
	var polylineOptions = drawingManager.get('polylineOptions');
		polylineOptions.strokeColor = color;
		drawingManager.set('polylineOptions', polylineOptions);
		
		var rectangleOptions = drawingManager.get('rectangleOptions');
		rectangleOptions.fillColor = color;
		drawingManager.set('rectangleOptions', rectangleOptions);
		
		var circleOptions = drawingManager.get('circleOptions');
		circleOptions.fillColor = color;
		drawingManager.set('circleOptions', circleOptions);
		
		var polygonOptions = drawingManager.get('polygonOptions');
		polygonOptions.fillColor = color;
		drawingManager.set('polygonOptions', polygonOptions);
	}
		
	function setSelectedShapeColor(color) {
		if (selectedShape) {
		  if (selectedShape.type == google.maps.drawing.OverlayType.POLYLINE) {
			selectedShape.set('strokeColor', '#B4B4B4');
		  } else {
			selectedShape.set('fillColor', color);
		  }
		}
	}
	
	function makeColorButton(color) {
		var button = document.createElement('span');
		button.className = 'color-button';
		button.style.backgroundColor = color;
		google.maps.event.addDomListener(button, 'click', function() {
		  selectColor(color);
		  setSelectedShapeColor(color);
		});
	
		return button;
	}
	
	function buildColorPalette() {
	 var colorPalette = document.getElementById('color-palette');
	 for (var i = 0; i < colors.length; ++i) {
	   var currColor = colors[i];
	   var colorButton = makeColorButton(currColor);
	   colorPalette.appendChild(colorButton);
	   colorButtons[currColor] = colorButton;
	 }
	 selectColor(colors[0]);
	}
	
	function initDrawingManager() {
		var polyOptions = {
		  strokeWeight: 0,
		  fillOpacity: 0.45,		 
		  strokeOpacity:0.5,
		  strokeWeight:2,
		  editable: true
		};
		// Creates a drawing manager attached to the map that allows the user to draw
		// markers, lines, and shapes.
		drawingManager = new google.maps.drawing.DrawingManager({          
			drawingControlOptions: {    
				position: google.maps.ControlPosition.TOP_LEFT,    
				drawingModes: [
					google.maps.drawing.OverlayType.CIRCLE,
					google.maps.drawing.OverlayType.RECTANGLE,
					google.maps.drawing.OverlayType.POLYGON
				]
			},		  
			circleOptions: polyOptions,
			rectangleOptions: polyOptions,
			polygonOptions: polyOptions,
			polylineOptions: polyOptions,
			map: map
		});
		
		google.maps.event.addListener(drawingManager, 'overlaycomplete', function(e) {
			if (e.type != google.maps.drawing.OverlayType.MARKER) {
				// Switch back to non-drawing mode after drawing a shape.
				drawingManager.setDrawingMode(null);
				var newShape = e.overlay;				
				newShape.type = e.type;
				newShape.zIndex = oIndex;
				overlayArray.push(newShape);
				oIndex += 1;
				// Add an event listener that selects the newly-drawn shape when the user
				// mouses down on it.
				google.maps.event.addListener(newShape, 'click', function() {
				  setSelection(newShape);				  
				});			
				
				google.maps.event.addListener(newShape, 'rightclick', function() {
				  	setSelection(newShape);	
					oContextMenu();				  
				});			
				
				setSelection(newShape);					
			}
		});
		
		
		// Clear the current selection when the drawing mode is changed, or when the
		// map is clicked.
		google.maps.event.addListener(drawingManager, 'drawingmode_changed', clearSelection);
				
		//eventListeners(map);
		//buildColorPalette();
		//drawSavedOverlay(map);
		//drawingControl();	
	}// End initDrawing Manager
	
		
	function initDrawingMap() {
		if (initZoom=="" || initZoom==0) initZoom = 16;	
		if (initLatlng=="") initLatlng = new google.maps.LatLng(14.4760787174,120.9934442026);
		try {
		map = new google.maps.Map(document.getElementById('map'), {
		  zoom: 16,
		  center: initLatlng,
		  mapTypeId: google.maps.MapTypeId.ROADMAP,          
		  zoomControl: true
		});
		}catch(err){alert()};
		
		drawControlStatus=false;
		//initDrawingManager(map);
		//return map;
	}