//Declare Global Variables
var selectedPage;
var itemsPerPage = 10;
var markersArray = [];

$(function() {


	$("#sidebar").on('click','span.pg',function() {
		var page = $(this).attr("id");
		setSelectedPage(page);
	});


	$("#sidebar").on('click','.vbutton',function() {
		var id = ($(this).parents('.sidebar_content').attr("id"));
		var x = id.replace("acctid-","");

		showVEDform(geolocations[x]['mlid']);
		return false;
	});


	$("#noitems").on('change',function() {
		$(".sidebar_nav_pages").html("");
		buildNavBar();
	});

	$("#sidebar").on('click','.sidebar_content',function() {
		var id = ($(this).attr("id"));
		var x = id.replace("acctid-","");
		var marker = focusMarker(x);
		return false;
	});

	$("#sidebar").on('click','.link',function() {
		return true;
	});

	$("#playback").hide();

});
// google.maps.event.addDomListener(window, 'load', initializeMap);

function initializeMap() {
	var initLatlng = new google.maps.LatLng(14.4760787174,120.9934442026);
	map = new google.maps.Map(document.getElementById('map'), {
	  zoom: 16,
	  center: initLatlng,
	  mapTypeId: google.maps.MapTypeId.ROADMAP,
	  zoomControl: true
	});
}

function createMarker(LatLng,title,icon) {
	var marker = new google.maps.Marker({
        position: LatLng,
        map: map,
		icon:icon,
        title:title
    });
	markersArray.push(marker);
	return marker;
}

/*
function createBubbleMarker(LatLng,$label,$location,$color) {
	var bMarker = new StyledMarker({
		styleIcon:new StyledIcon(StyledIconTypes.BUBBLE,
		{color:$color, text: $label}),
		position: LatLng,
		title:$location,
		map: map
	 });
	markersArray.push(bMarker);
    //
	hoverWindow(bMarker, $label + "<br/>" + $location);
}*/

function createBubbleMarker(LatLng,$label,$location,$color) {
	var image = "http://cdn.xplus.ph/assets/custom/";
	var icon = 'http://moses.xpluscloud.com/assets/images/Assets-CashWraps-10.png';

	if ($color=="00ff00") image += "greenbox.php?txt="+$label;
	else image += "redbox.php?txt="+$label;
	var bMarker = new google.maps.Marker({
        position: LatLng,
        map: map,
        icon: icon,
        title:$label,
		zIndex:9990
	 });
	markersArray.push(bMarker);
	hoverWindow(bMarker, $label + "<br/>" + $location);
}


function createIconMarker(i,icon) {
	var $label = (i+1) + " - " + geolocations[i]['label'];
	var myLatLng = new google.maps.LatLng(geolocations[i]['lat'],geolocations[i]['lng']);
	var iMarker = new google.maps.Marker({
        position: myLatLng,
        map: map,
		icon:icon,
        title:$label,
		zIndex:9990
    });
	markersArray.push(iMarker);

}

function placeMarkers(page) {
		var x = parseInt(page.replace('pg-','')) - 1;
		x *= itemsPerPage;
		$('#sidebar_body').html("");
		var bounds = new google.maps.LatLngBounds();
		var maxItem = parseInt(x)+parseInt(itemsPerPage);

		for (var i=x; i < maxItem; i++) {
			if (i >= geolocations.length) break;
			var loc = geolocations[i];
			var LatLng = new google.maps.LatLng(loc.lat,loc.lng);
			var label = parseInt((i+1)) + ".) " + loc.label;
			var location = loc.location;
			switch(mapCategory) {
				case 1:
					var color = loc.bgcolor;
					if (i==0) lastKnownLocation(i);
					else createBubbleMarker(LatLng,label,location,color);
					break;
				case 2:
				case 3:
					var color="00ff00"; //Green
					createBubbleMarker(LatLng,label,location,color);
					break;
			}
			bounds.extend(LatLng);
			fillSidebar(i,location,label);

		}
		map.fitBounds(bounds); // Adjust zoom to fit all markers in the map view
		$('<span><label class="vbutton badge badge-warning pull-right">View</label></span>').appendTo('.link');

	}


function clearMarkers() {
	if (markersArray) {
		var i;
		for (i in markersArray) {
			markersArray[i].setMap(null);
		}
	}
	markersArray.length = 0;
}


function focusMarker(x) {
	clearMarkers();

	var LatLng = new google.maps.LatLng(geolocations[x]['lat'],geolocations[x]['lng']);
	var title;
	var $draggable=false;
	var glid=geolocations[x]['mlid'];
	switch(mapCategory) {
		case 1: //Individual subscriber Tracking Map
			title = geolocations[x]['label'];
			break;
		case 2: //Geolocations Map
			var ix = parseInt(x)+1;
                        title = '<strong>' + ix + '.) ' + geolocations[x]['label'] +'</strong><br>';
                        title +=getLocation(x);
			title += '<div style="color:#800000"> Lat: ' +  geolocations[x]['lat'] +'</div>';
			title += '<div style="color:#800000"> Lng: ' +  geolocations[x]['lng'] +'</div>';
			$draggable=true;
			break;
	}
	var lat;
	var lng;
	var marker = new google.maps.Marker({
		position: LatLng,
		map: map,
		draggable:$draggable,
		title:title
	});
	map.setZoom(16);
	map.setCenter(LatLng);

	markersArray.push(marker);

	createInfoWindow(marker,title)

	google.maps.event.addListener(marker, 'click', function(e) {
		alert(marker.getTitle());
	});

	if ($draggable) {
		google.maps.event.addListener(marker, 'rightclick', function(e) {
			mContextMenu(lat,lng);
		});

		google.maps.event.addListener(marker, "dragend", function(event) {
			var myLatLng = event.latLng;
			lat  = myLatLng.lat();
			lng = myLatLng.lng();

		   //point = marker.getPosition();
		   map.panTo(point);
		});

		google.maps.event.addDomListener(document.getElementById('save-marker'), 'click', function(e) {
			saveFocusMarker(glid,lat,lng);
		});

		google.maps.event.addDomListener(document.getElementById('cancel-save-marker'), 'click', function(e) {
			$('#mcontextmenu').hide();
		});
	}
	$('#mcontextmenu').hide();
	return marker;
}

//************************************************

function mContextMenu(lat,lng) {
	if(!lat || !lng) return false;
	$('#mcontextmenu').show();
	return false;
}


function saveFocusMarker($glid,$lat,$lng) {
	$('#mcontextmenu').hide();
	//confirm("About to update marker position..." );
	var $waid;
	try {
		$waid = $('#filterdev').val();
	}
	catch(e) {
		$waid = 0;
	}
	aurl="http://xplustrack.com/_ajx/router.php";
	param = {tkrid:$tkrid,dpage:'update-marker',lat:$lat,lng:$lng,glid:$glid};
	ajpost(aurl,param);

}

//************************************************

function createInfoWindow(marker,contentString) {
	var infowindow = new google.maps.InfoWindow({
		content: contentString,
		maxWidth: 200,
		maxHeight:150
	});
	infowindow.open(map,marker);
}

function lastKnownLocation(i) {
	// alert(1);
	var data = geolocations[i];

	var LatLng = new google.maps.LatLng(data.lat,data.lng);

	var infoText = "<b>" + data.label.toUpperCase() + "</b><br/>";
		infoText += data.location;
		var marker = createBouncingMarker(LatLng,infoText);
		hoverWindow(marker,infoText);

}


function hoverWindow(marker,textInfo) {
	var boxText = document.createElement("div");
		boxText.style.cssText = "border: 1px solid #006A00; margin-top: 8px; padding-left:8px; background: #E2FFC6; padding: 5px;";
		boxText.innerHTML=textInfo;

	var ibOptions = {
		content: boxText,
		disableAutoPan: false,
		maxWidth: 0,
		pixelOffset: new google.maps.Size(-140, 0),
			zIndex: null,
			boxStyle: {
				background: "url('http://xplusglobal.com/des/assets/images/tipbox.gif') no-repeat",
			  	opacity: 0.8,
			  	width: "280px"
			},
			closeBoxMargin: "10px 2px 2px 2px",
			closeBoxURL: "http://www.google.com/intl/en_us/mapfiles/close.gif",
			infoBoxClearance: new google.maps.Size(1, 1),
			isHidden: false,
			pane: "floatPane",
			enableEventPropagation: false
		};


		google.maps.event.addListener(marker, "mouseover", function() {
			ib.open(map, marker);
		});

		google.maps.event.addListener(marker, "mouseout", function() {
			ib.close();
		});

		var ib = new InfoBox(ibOptions);

}

/*
function hoverWindow(marker,textInfo) {
	var infowindow = new google.maps.InfoWindow({
		content: textInfo,
		maxWidth: 200,
		maxHeight:350
	});
//
	google.maps.event.addListener(marker, "mouseover", function() {
		infowindow.open(map, marker);
	});
	google.maps.event.addListener(marker, "mouseout", function() {
		infowindow.close();
	});
}
*/

function createBouncingMarker(LatLng,infoText) {
	var marker = new google.maps.Marker({
        position: LatLng,
        map: map,
		animation: google.maps.Animation.BOUNCE,
        title:infoText
    });
	markersArray.push(marker);
	//marker.setAnimation(google.maps.Animation.BOUNCE);
	google.maps.event.addListener(marker, 'click', toggleBounce);
	return marker;
}

function toggleBounce() {
	if (marker.getAnimation() != null) {
		marker.setAnimation(null);
	}
	else {
		marker.setAnimation(google.maps.Animation.BOUNCE);
	}
}

var poly;
function playback() {
	clearMarkers();
	var x = parseInt(selectedPage.replace('pg-','')) - 1;
	x *= itemsPerPage;
	var maxItem = parseInt(x)+parseInt(itemsPerPage);
	if (maxItem > geolocations.length) maxItem = geolocations.length - 1;

	var polyOptions = {
		strokeColor: '#4A0000',
		strokeOpacity: 0.3,
		strokeWeight: 2  }
	poly = new google.maps.Polyline(polyOptions);
	poly.setMap(map);

	dropMarker(maxItem,x);
}


function dropMarker(i,x) {
	if (i<x) return;
	var data = geolocations[i];
	var LatLng = new google.maps.LatLng(data.lat,data.lng);
	var marker = new google.maps.Marker({
		position: LatLng,
		map: map,
		animation: google.maps.Animation.DROP
	});
	hoverWindow(marker,i+1 + ".) " + data.label + "<br/>" + data.location);

	createPoly(LatLng);
	markersArray.push(marker);
	var t=setTimeout("dropMarker("+(i-1)+","+ x +")",400);
}

function createPoly(LatLng) {
	var path = poly.getPath();
	path.push(LatLng);
}

//*********************************************************
// Fill SideBar
//*********************************************************
function fillSidebar(i,location,label) {
	var divid = 'acctid-' + i;
	$('<div id="' + divid +'" class ="sidebar_content"></div>').appendTo("#sidebar_body");

	$('<div class ="link">' + label + '</div>').appendTo("#" + divid);
	$('<div class ="address">' + location + '</div>').appendTo("#" + divid);
}

function getLocation(i) {
	var $location;
	var data = geolocations[i];

	$location = data.location;
	//$location += ' ' + geolocations[i]['brgy'];
	//$location += ' ' + geolocations[i]['city'];
	//$location += ' ' + geolocations[i]['province'];
	return $location;
}


//*********************************************************
// Create Map Page Navigation Utility
//*********************************************************

function setSelectedPage(page) {
	//remove selected color class from old Selected Page
	$("#"+selectedPage).removeClass("selected-page");

	selectedPage=page;
	$("#"+selectedPage).addClass("selected-page");

	//fill Sidebar Body
	clearMarkers();
	placeMarkers(selectedPage);
}

function makePageLink(page) {
	var zpage;

	if (page<10)  zpage = '0' + page;
	else zpage = page;
	var newPageLink = '<span class="pg" id="pg-' + page + '"  title="pg-' + page + '">'+ zpage + '</span>';
	return newPageLink;
}

function buildNavBar() {
	var pgcols=10;

	if (geolocations.length > 0) {
		itemsPerPage = $("#noitems").val();

		if (geolocations.length > itemsPerPage ) {
			$nopages = parseInt(geolocations.length/itemsPerPage);
			if ((geolocations.length % itemsPerPage) > 0)  $nopages++;
		}
		else $nopages=1;
		if (geolocations.length > 2000) pgcols=8;
		for (var i=1;i<=$nopages;i++) {
			if (i-1>0 && (i-1)%pgcols == 0) $(".sidebar_nav_pages").append('<br/>');
			$(".sidebar_nav_pages").append(makePageLink(i));
		}

		setSelectedPage("pg-1");
	}
	else {
		$(".sidebar_nav_pages").append('<h3 style="color:#ff0000">No Records Found!</h4>');
	}
}
// google.maps.event.addDomListener(window, 'load', initializeMap);
